<?php
/**
 * File 2017_01_14_183312_seed_ticket_channel_table.php
 *
 * @package    Database\Seeds\v2_1_1
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.1
 */
namespace Database\Seeds\v2_1_1;

use Addons\Channels\Email\Controllers\Email;
use App\Modules\Ticket\Models\Channel;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedTicketChannelTable
 *
 * @package    Database\Seeds\v2_1_1
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.1
 */
class SeedTicketChannelTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $channel = Channel::where('name', Email::IDENTIFIER)->first();

        DB::table('ticket_channel_setting')->insert([
            'channel_id' => $channel->id,
            'name'       => 'prioritise_reply-to',
            'value'      => 1,
            'created_at' => time(),
            'updated_at' => time()
        ]);
    }
}
