<?php
/**
 * File 2017_03_26_189200_seed_email_template_table.php
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_1_2;

use DB;
use App\Modules\Core\Models\EmailTemplate;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateTable
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedEmailTemplateTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        if (! DB::table('email_template')->where('id', 27)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template')->insert([
                [
                    'id'          => 27,
                    'name'        => 'Ticket email replies disabled',
                    'description' => '',
                    'type'        => EmailTemplate::USER,
                    'created_at'  => $time,
                    'updated_at'  => $time,
                ]
            ]);
        }
    }
}
