<?php
/**
 * File 2017_03_26_189201_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Seeds\v2_1_2;

use App\Modules\Core\Models\EmailTemplate;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        if (DB::table('email_template')->where('id', 27)->where('type', EmailTemplate::USER)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template_data')->insert([
                [
                    'template_id' => 27,
                    'subject'     => 'Your message could not be accepted',
                    'contents'    => file_get_contents(__DIR__ . '/emails/template_27.twig'),
                    'created_at'  => $time,
                    'updated_at'  => $time
                ]
            ]);
        }

        // Remove "Dear operator.formatted_name" from Department Changed email template.
        DB::update(
            "UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'Dear {{ operator.formatted_name }},<br>\n<br>\n', '') WHERE `template_id` = 19"
        );

        // Updating latestMessage relation to lastReply
        DB::update(
            "UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'ticket.latestMessage', 'ticket.lastReply')"
        );
    }
}
