<?php
/**
 * File 2017_03_26_189202_seed_last_reply_table.php
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Seeds\v2_1_2;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedLastReplyTable
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class SeedLastReplyTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Updating latestMessage relation to lastReply
        DB::update(
            "UPDATE `canned_response` SET `text` = REPLACE(`text`, 'ticket.latestMessage', 'ticket.lastReply')"
        );
        DB::update(
            "UPDATE `operator_signature` SET `contents` = REPLACE(`contents`, 'ticket.latestMessage', 'ticket.lastReply')"
        );
        DB::update(
            "UPDATE `sla_escalation_rule` SET `value_text` = REPLACE(`value_text`, 'ticket.latestMessage', 'ticket.lastReply')"
        );
        DB::update(
            "UPDATE `ticket_followup_action` SET `value_text` = REPLACE(`value_text`, 'ticket.latestMessage', 'ticket.lastReply')"
        );
        DB::update(
            "UPDATE `ticket_macro_action` SET `value_text` = REPLACE(`value_text`, 'ticket.latestMessage', 'ticket.lastReply')"
        );
    }
}
