<?php
/**
 * File 2017_03_26_189203_seed_operator_setting_table.php
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Seeds\v2_1_2;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedOperatorSettingTable
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class SeedOperatorSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Adding attachments column to operator ticket grid columns.
        DB::update(
            "UPDATE `operator_setting` SET `ticket_grid_columns` = REPLACE(`ticket_grid_columns`, ',\"subject\"', ',\"attachments\":1,\"subject\"')"
        );
    }
}
