<?php
/**
 * File 2017_03_26_189204_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Seeds\v2_1_2;

use Addons\Channels\Email\Controllers\Email;
use App\Modules\Ticket\Models\Channel;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_1_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $channel = Channel::where('name', Email::IDENTIFIER)->first();

        // Disable verbose email log.
        DB::table('ticket_channel_setting')
            ->where('channel_id', $channel->id)
            ->where('name', 'verbose_log')
            ->update([ 'value' => 0 ]);
    }
}
