<?php
/**
 * File 2017_09_01_198000_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_2_0\
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Seeds\v2_2_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_2_0
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Overwrite default e-mail templates if they're the same as what we ship in the 2.0.0-beta1 seeds for 2.1.2.
        $this->updateTemplate(1);
        $this->updateTemplate(2);
        $this->updateTemplate(3);
        $this->updateTemplate(4);
        $this->updateTemplate(5);
        $this->updateTemplate(11);
        $this->updateTemplate(13);
        $this->updateTemplate(18);
        $this->updateTemplate(19);
        $this->updateTemplate(20);
        $this->updateTemplate(23);
        $this->updateTemplate(24);

        // Replace ip_address/operator_url with model attribute for URL
        DB::update(
            "UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, '{{ ip_address }}', '{{ ban.ip }}') WHERE `template_id` = 7"
        );
        DB::update(
            "UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, '{{ operator_url }}', '{{ ban.operator_edit_url }}') WHERE `template_id` = 7"
        );
        DB::update(
            "UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, '{{ operator_url }}', '{{ comment.operator_edit_url }}') WHERE `template_id` = 17"
        );
    }

    /**
     * Overwrite email template if the updated time is the same as the created time.
     *
     * @param  int    $id
     * @return void
     */
    private function updateTemplate($id)
    {
        // Check template file exists.
        $template = __DIR__.'/../2.0.0-beta1/emails/template_'.$id.'.twig';
        if (! file_exists($template)) {
            $this->note("[ERROR]: Failed to update email template '$id', template data file could not be found.");
            return;
        }

        // Check if the template has been modified.
        $unmodified = DB::table('email_template_data')
            ->where('template_id', $id)
            ->whereColumn('created_at', 'updated_at')
            ->whereNull('brand_id')
            ->whereNull('language_code')
            ->count();

        if ($unmodified) {
            DB::table('email_template_data')
                ->where('template_id', $id)
                ->whereColumn('created_at', 'updated_at')
                ->whereNull('brand_id')
                ->whereNull('language_code')
                ->update([ 'contents' => file_get_contents($template) ]);
        } else {
            $this->note("[INFO]: Unable to update email template '$id', template has likely been modified. Please read the 2.2 Upgrade Guide (docs.supportpal.com).");
        }
    }
}
