<?php
/**
 * File 2017_09_01_198002_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_2_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Seeds\v2_2_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_2_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        // Only insert if it doesn't currently exist.
        if (! DB::table('setting')->where('name', 'attachment_size')->count()) {
            DB::table('setting')->insert([
                'module_id'  => 1,
                'name'       => 'attachment_size',
                'value'      => '10M',
                'created_at' => $time,
                'updated_at' => $time
            ]);
        }

        if (! DB::table('setting')->where('name', 'operator_name_format')->count()) {
            // Copy the user name format
            $format = DB::table('setting')->where('name', 'user_name_format')->first();

            DB::table('setting')->insert([
                'module_id'  => 2,
                'name'       => 'operator_name_format',
                'value'      => empty($format) ? 0 : $format->value,
                'created_at' => $time,
                'updated_at' => $time
            ]);
        }
    }
}
