<?php
/**
 * File 2018_01_01_143000_seed_email_template_table.php
 *
 * @package    Database\Seeds\v2_3_0
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Seeds\v2_3_0;

use App\Modules\Core\Models\EmailTemplate;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateTable
 *
 * @package    Database\Seeds\v2_3_0
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class SeedEmailTemplateTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        if (! DB::table('email_template')->where('id', 28)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template')->insert([
                [
                    'id'          => 28,
                    'name'        => 'Registered users only',
                    'description' => '',
                    'type'        => EmailTemplate::USER,
                    'created_at'  => $time,
                    'updated_at'  => $time,
                ]
            ]);
        }

        if (! DB::table('email_template')->where('id', 29)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template')->insert([
                [
                    'id'          => 29,
                    'name'        => 'New user reply',
                    'description' => '',
                    'type'        => EmailTemplate::USER,
                    'created_at'  => $time,
                    'updated_at'  => $time,
                ]
            ]);
        }
    }
}
