<?php
/**
 * File 2018_01_01_143001_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_3_0
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Seeds\v2_3_0;

use App\Modules\Core\Models\EmailTemplate;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_3_0
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        if (DB::table('email_template')->where('id', 28)->where('type', EmailTemplate::USER)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template_data')->insert([
                [
                    'template_id' => 28,
                    'subject'     => 'Support Ticket Not Opened',
                    'contents'    => file_get_contents(__DIR__ . '/emails/template_28.twig'),
                    'created_at'  => $time,
                    'updated_at'  => $time
                ]
            ]);
        }

        if (DB::table('email_template')->where('id', 29)->where('type', EmailTemplate::USER)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template_data')->insert([
                [
                    'template_id' => 29,
                    'subject'     => '(#{{ ticket.number }}) {{ ticket.subject }}',
                    'contents'    => file_get_contents(__DIR__ . '/emails/template_29.twig'),
                    'created_at'  => $time,
                    'updated_at'  => $time
                ]
            ]);
        }

        // DEV-1755: we accidentally overwrote template changes in 2.2.0-beta1
        // This is a copy of UPDATE SQL for the affected templates from previous versions (prior to 2.2.0-beta1).
        DB::update("UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'system.company', 'brand.name')");
        DB::update("UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'system.email', 'brand.default_email')");
        DB::update("UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'system.url', 'brand.frontend_url')");
        DB::update("UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'system.waiting_response_time', 'settings.waiting_response_time') WHERE `template_id` = '11'");
        DB::update("UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'system.inactive_close_time', 'settings.inactive_close_time') WHERE `template_id` = '11'");
        DB::update("UPDATE `email_template_data` SET `contents` = REPLACE(`contents`, 'Dear {{ operator.formatted_name }},<br>\n<br>\n', '') WHERE `template_id` = 19");

        // Overwrite default e-mail templates if they're the same as what we ship in the 2.0.0-beta1 seeds for 2.2.0.
        $this->updateTemplate(1);
        $this->updateTemplate(4);
        $this->updateTemplate(5);
        $this->updateTemplate(18);
        $this->updateTemplate(19);
        $this->updateTemplate(23);
        $this->updateTemplate(24);
    }

    /**
     * Overwrite email template if the updated time is the same as the created time.
     *
     * @param  int    $id
     * @return void
     */
    private function updateTemplate($id)
    {
        // Check template file exists.
        $template = __DIR__.'/../2.0.0-beta1/emails/template_'.$id.'.twig';
        if (! file_exists($template)) {
            $this->note("[ERROR]: Failed to update email template '$id', template data file could not be found.");
            return;
        }

        // Check if the template has been modified.
        $unmodified = DB::table('email_template_data')
            ->where('template_id', $id)
            ->whereColumn('created_at', 'updated_at')
            ->whereNull('brand_id')
            ->whereNull('language_code')
            ->count();

        if ($unmodified) {
            DB::table('email_template_data')
                ->where('template_id', $id)
                ->whereColumn('created_at', 'updated_at')
                ->whereNull('brand_id')
                ->whereNull('language_code')
                ->update([ 'contents' => file_get_contents($template) ]);
        } else {
            $this->note("[INFO]: Unable to update email template '$id', template has likely been modified. Please read the 2.3 Upgrade Guide (docs.supportpal.com).");
        }
    }
}
