<?php
/**
 * File 2018_01_01_143002_seed_ticket_channel_setting_table.php
 *
 * @package    Database\Seeds\v2_3_0
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Seeds\v2_3_0;

use Addons\Channels\Email\Controllers\Email;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\Core\Models\Repository\SettingsRepository;
use App\Modules\Ticket\Models\Channel;
use App\Modules\Ticket\Models\ChannelSetting;
use DB;

/**
 * Class SeedTicketChannelSettingTable
 *
 * @package    Database\Seeds\v2_3_0
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class SeedTicketChannelSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $channel = Channel::where('name', Email::IDENTIFIER)->first();

        // Get current registered_users email channel setting.
        $registeredUsersOnly = channel_config('email.settings.registered_users', false);

        // Delete registered_users email channel setting.
        ChannelSetting::where('channel_id', $channel->id)->where('name', 'registered_users')->delete();

        // Enable registered users only for all departments if the channel setting is enabled.
        if ($this->container->make(SettingsRepository::class)->isInstalled() && $registeredUsersOnly) {
            DB::table('department')->update([ 'registered_only' => 1 ]);

            $departments = DB::table('department')->get();
            foreach ($departments as $department) {
                if (isset($department->email_templates)) {
                    $templates = json_decode($department->email_templates, true);

                    // Set to disabled initially to provide backwards compatibility with how it worked before
                    $templates['user_ticket_registeredonly'] = -1;

                    DB::table('department')->where('id', $department->id)
                        ->update([ 'email_templates' => json_encode($templates) ]);
                }
            }
        }
    }
}
