<?php
/**
 * File 2018_05_04_123000_seed_action_table.php
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Seeds\v2_3_1;

use App\Modules\Ticket\Models\FollowUpAction;
use App\Modules\Ticket\Models\MacroAction;
use App\Modules\Ticket\Models\SlaEscalationRule;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedActionTable
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class SeedActionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $actions = MacroAction::whereIn('action', [ 0, 1 ])->get();
        foreach ($actions as $action) {
            $this->updateAction($action);
        }

        $actions = FollowUpAction::whereIn('action', [ 0, 1 ])->get();
        foreach ($actions as $action) {
            $this->updateAction($action);
        }

        $actions = SlaEscalationRule::whereIn('action', [ 0, 1 ])->get();
        foreach ($actions as $action) {
            $this->updateAction($action);
        }
    }

    /**
     * Update value text so it's a json encoded array.
     *
     * @param mixed $action
     * @return void
     */
    private function updateAction($action)
    {
        $action->value_text = json_encode([ 'text' => $action->value_text ]);
        $action->save();
    }
}
