<?php
/**
 * File 2018_05_04_123001_seed_email_template_table.php
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Seeds\v2_3_1;

use App\Modules\Core\Models\EmailTemplate;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateTable
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class SeedEmailTemplateTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        if (! DB::table('email_template')->where('id', 30)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template')->insert([
                [
                    'id'          => 30,
                    'name'        => 'User export ready',
                    'description' => '',
                    'type'        => EmailTemplate::OPERATOR,
                    'created_at'  => $time,
                    'updated_at'  => $time,
                ]
            ]);
        }
    }
}
