<?php
/**
 * File 2018_05_04_123002_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Seeds\v2_3_1;

use App\Modules\Core\Models\EmailTemplate;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::update(
            "UPDATE `email_template_data`
                   SET `contents` = REPLACE(`contents`, 'comment.article.frontendUrl(comment.type)', 'comment.article.url(comment.type)')
                   WHERE `template_id` = '10' OR `template_id` = '17'"
        );

        $time = time();

        if (DB::table('email_template')->where('id', 30)->where('type', EmailTemplate::OPERATOR)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template_data')->insert([
                [
                    'template_id' => 30,
                    'subject'     => 'User export ready',
                    'contents'    => file_get_contents(__DIR__ . '/emails/template_30.twig'),
                    'created_at'  => $time,
                    'updated_at'  => $time
                ]
            ]);
        }
    }
}
