<?php
/**
 * File 2018_05_04_123003_seed_permission_table.php
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Seeds\v2_3_1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedPermissionTable
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class SeedPermissionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            [ 'module_id' => 2, 'name' => 'sociallogin' ],
        ];

        foreach ($permissions as $permission) {
            $id = DB::table('permission')->insertGetId([
                'module_id'     => $permission['module_id'],
                'name'          => $permission['name'],
                'slug'          => '{"view":true,"create":true,"update":true,"delete":true}',
                'description'   => $permission['name'],
                'created_at'    => time(),
                'updated_at'    => time(),
            ]);

            // Get first role
            $role = DB::table('role')->first();

            // Add relationship for permission and role
            DB::table('permission_role')->insert([
                'permission_id' => $id,
                'role_id'       => $role->id
            ]);
        }
    }
}
