<?php
/**
 * File 2018_05_04_123004_seed_scheduled_task_table.php
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Seeds\v2_3_1;

use App\Modules\Core\Controllers\Operator\SystemCleanupController;
use App\Modules\Core\Models\ExportQueue;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class SeedScheduledTaskTable
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class SeedScheduledTaskTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('scheduled_task')->insert([
            [
                'name'        => 'Generate exports',
                'description' => 'Generate scheduled exports and store them on to the file system.',
                'class'       => ExportQueue::class,
                'interval'    => 285,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ],
            [
                'name'        => 'Automatically delete old data, files and logs',
                'description' => 'Remove data from the database, files and logs after a certain number of days, configured via the System Cleanup page.',
                'class'       => SystemCleanupController::class,
                'interval'    => 86385,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ],
        ]);
    }
}
