<?php
/**
 * File 2018_05_04_123005_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.1
 */
namespace Database\Seeds\v2_3_1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_3_1
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.1
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        // Remove send_diagnostic setting.
        DB::table('setting')->where('module_id', 1)->where('name', 'send_diagnostic')->delete();

        DB::table('setting')->insert([
            [
                'module_id'  => 1,
                'name'       => 'captcha_type',
                'value'      => '1',
                'created_at' => $time,
                'updated_at' => $time
            ],
            [
                'module_id'  => 1,
                'name'       => 'upgrade_time',
                'value'      => $time,
                'created_at' => $time,
                'updated_at' => $time,
            ],
            [
                'module_id'  => 1,
                'name'       => 'last_email_log_id',
                'value'      => '',
                'created_at' => $time,
                'updated_at' => $time
            ]
        ]);
    }
}
