<?php
/**
 * File 2018_10_01_129000_seed_action_table.php
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Seeds\v2_4_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedActionTable
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class SeedActionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Update all action tables
        $this->updateTable('sla_escalation_rule');
        $this->updateTable('ticket_macro_action');
        $this->updateTable('ticket_followup_action');
    }

    /**
     * Update all instances within the table
     *
     * @param string $table
     * @return void
     */
    private function updateTable($table)
    {
        $sql = "UPDATE `{$table}`
                SET `value_text` = REPLACE(`value_text`, 'message.text', 'message.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `{$table}`
                SET `value_text` = REPLACE(`value_text`, 'lastReply.text', 'lastReply.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `{$table}`
                SET `value_text` = REPLACE(`value_text`, 'operator.signature', 'operator.signature|raw')";
        DB::update($sql);
    }
}
