<?php
/**
 * File 2018_10_01_129001_seed_canned_response_table.php
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Seeds\v2_4_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedCannedResponseTable
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class SeedCannedResponseTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Update both tables
        $this->updateTable('canned_response');
        $this->updateTable('canned_response_translation');
    }

    /**
     * Update all instances within the table
     *
     * @param string $table
     * @return void
     */
    private function updateTable($table)
    {
        $sql = "UPDATE `{$table}`
                SET `text` = REPLACE(`text`, 'message.text', 'message.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `{$table}`
                SET `text` = REPLACE(`text`, 'lastReply.text', 'lastReply.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `{$table}`
                SET `text` = REPLACE(`text`, 'operator.signature', 'operator.signature|raw')";
        DB::update($sql);
    }
}
