<?php
/**
 * File 2018_10_01_129002_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Seeds\v2_4_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $sql = "UPDATE `email_template_data`
                SET `contents` = REPLACE(
                    `contents`,
                     'data:image/png;base64,{{ message.user.avatar }}',
                      '{{ message.user.avatar_url }}'
                )";
        DB::update($sql);

        $sql = "UPDATE `email_template_data`
                SET `contents` = REPLACE(`contents`, 'message.text', 'message.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `email_template_data`
                SET `contents` = REPLACE(`contents`, 'lastReply.text', 'lastReply.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `email_template_data`
                SET `contents` = REPLACE(`contents`, 'operator.signature', 'operator.signature|raw')";
        DB::update($sql);

        $sql = "UPDATE `email_template_data`
                SET `contents` = REPLACE(`contents`, 'comment.text', 'comment.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `email_template_data`
                SET `contents` = REPLACE(`contents`, '{{ private.message }}', '{{ private.purified_message|raw }}')
                WHERE `id` = 15";
        DB::update($sql);

        $replacement = <<<EOD
    {% if custom_field.field.type == 9 %}
        {{ Purifier.clean(custom_field.value) }}
    {% else %}
        {{ custom_field.value }}
    {% endif %}
EOD;
        $sql = "UPDATE `email_template_data`
                SET `contents` = REPLACE(`contents`, '{{ custom_field.value }}', '$replacement')";
        DB::update($sql);
    }
}
