<?php
/**
 * File 2018_10_01_129003_seed_operator_signature_table.php
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.4.0
 */
namespace Database\Seeds\v2_4_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedOperatorSignatureTable
 *
 * @package    Database\Seeds\v2_4_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.4.0
 */
class SeedOperatorSignatureTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $sql = "UPDATE `operator_signature`
                SET `contents` = REPLACE(`contents`, 'message.text', 'message.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `operator_signature`
                SET `contents` = REPLACE(`contents`, 'lastReply.text', 'lastReply.purified_text|raw')";
        DB::update($sql);

        $sql = "UPDATE `operator_signature`
                SET `contents` = REPLACE(`contents`, 'operator.signature', 'operator.signature|raw')";
        DB::update($sql);
    }
}
