<?php
/**
 * File 2019_01_01_129300_seed_email_template_table.php
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Seeds\v2_5_0;

use App\Modules\Core\Models\EmailTemplate;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateTable
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class SeedEmailTemplateTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        if (! DB::table('email_template')->where('id', 31)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template')->insert([
                [
                    'id'          => 31,
                    'name'        => 'Updated email address',
                    'description' => '',
                    'type'        => EmailTemplate::USER,
                    'created_at'  => $time,
                    'updated_at'  => $time,
                ]
            ]);
        }

        if (! DB::table('email_template')->where('id', 32)->count()) {
            // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
            DB::table('email_template')->insert([
                [
                    'id'          => 32,
                    'name'        => 'Confirm new email address',
                    'description' => '',
                    'type'        => EmailTemplate::USER,
                    'created_at'  => $time,
                    'updated_at'  => $time,
                ]
            ]);
        }
    }
}
