<?php
/**
 * File 2019_01_01_129301_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Seeds\v2_5_0;

use App\Modules\Core\Models\EmailTemplate;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2018 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        if (DB::table('email_template')->where('id', 31)->where('type', EmailTemplate::USER)->count()) {
            DB::table('email_template_data')->insert([
                [
                    'template_id' => 31,
                    'subject'     => 'We\'ve updated your email address',
                    'contents'    => file_get_contents(__DIR__ . '/emails/template_31.twig'),
                    'created_at'  => $time,
                    'updated_at'  => $time
                ]
            ]);
        }

        if (DB::table('email_template')->where('id', 32)->where('type', EmailTemplate::USER)->count()) {
            DB::table('email_template_data')->insert([
                [
                    'template_id' => 32,
                    'subject'     => 'Confirm your new email address',
                    'contents'    => file_get_contents(__DIR__ . '/emails/template_32.twig'),
                    'created_at'  => $time,
                    'updated_at'  => $time
                ]
            ]);
        }
    }
}
