<?php
/**
 * File 2019_01_01_129302_seed_permission_table.php
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Seeds\v2_5_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedPermissionTable
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class SeedPermissionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            [ 'module_id' => 3, 'name' => 'ticket_trash' ],
        ];

        foreach ($permissions as $permission) {
            $id = DB::table('permission')->insertGetId([
                'module_id'     => $permission['module_id'],
                'name'          => $permission['name'],
                'slug'          => '{"delete":true}',
                'description'   => $permission['name'],
                'created_at'    => time(),
                'updated_at'    => time(),
            ]);

            // Fetch existing ticket delete permission.
            $deletePermission = DB::table('permission')
                ->where('name', 'ticket')
                ->where('slug', '{"delete":true}')
                ->first();

            if (! empty($deletePermission)) {
                $deletePermission = $deletePermission->id;

                // Get roles that have this permission
                $roles = DB::table('permission_role')
                    ->where('permission_id', $deletePermission)
                    ->pluck('role_id')
                    ->all();

                foreach ($roles as $role) {
                    // Add relationship for permission and role
                    DB::table('permission_role')->insert([
                        'permission_id' => $id,
                        'role_id'       => $role
                    ]);
                }
            } else {
                // Fallback - Get first role
                $role = DB::table('role')->first();

                // Add relationship for permission and role
                DB::table('permission_role')->insert([
                    'permission_id' => $id,
                    'role_id'       => $role->id
                ]);
            }
        }
    }
}
