<?php
/**
 * File 2019_03_22_163000_seed_widget_table.php
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Seeds\v2_5_0;

use App\Modules\Core\Controllers\Addons\Manager;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;

/**
 * Class SeedWidgetTable
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class SeedWidgetTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // We use discover() here because the WidgetFactory isn't available for new installs.
        $driver = app()->make(Manager::class)->driver('widget');
        $widgets = $driver->discover();

        // Set the version for each widget
        foreach ($widgets as $name => $widget) {
            if (isset($widget->getConfig()->version)) {
                DB::table('widget')->where('name', $name)->update([ 'version' => $widget->getConfig()->version ]);
            }
        }
    }
}
