<?php
/**
 * File 2019_04_16_123500_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.0
 */
namespace Database\Seeds\v2_5_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\Core\Models\Repository\SettingsRepository;
use DB;

use function time;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_5_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.0
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable gravatar on new installs.
        $useGravatar = $this->container->make(SettingsRepository::class)->isInstalled() !== false ? 1 : 0;

        DB::table('setting')->insert([
            'module_id'  => 2,
            'name'       => 'use_gravatar',
            'value'      => $useGravatar,
            'created_at' => time(),
            'updated_at' => time()
        ]);
    }
}
