<?php
/**
 * File 2019_05_18_121600_seed_ticket_channel_account_info_table.php
 *
 * @package    Database\Seeds\v2_5_1
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.5.1
 */
namespace Database\Seeds\v2_5_1;

use Addons\Channels\Facebook\Controllers\Facebook;
use Addons\Channels\Twitter\Controllers\Twitter;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\Ticket\Models\ChannelAccount;
use DB;

/**
 * Class SeedTicketChannelAccountInfoTable
 *
 * @package    Database\Seeds\v2_5_1
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.5.1
 */
class SeedTicketChannelAccountInfoTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        $accounts = ChannelAccount::with('channel')->get();

        foreach ($accounts as $account) {
            if ($account->channel->name == Facebook::IDENTIFIER) {
                // Facebook
                DB::table('ticket_channel_account_info')->insert([
                    [
                        'account_id' => $account->id,
                        'name'       => 'import_posts',
                        'value'      => 1,
                        'created_at' => $time,
                        'updated_at' => $time
                    ],
                    [
                        'account_id' => $account->id,
                        'name'       => 'import_messages',
                        'value'      => 1,
                        'created_at' => $time,
                        'updated_at' => $time
                    ]
                ]);
            } else if ($account->channel->name == Twitter::IDENTIFIER) {
                // Twitter
                DB::table('ticket_channel_account_info')->insert([
                    [
                        'account_id' => $account->id,
                        'name'       => 'import_tweets',
                        'value'      => 1,
                        'created_at' => $time,
                        'updated_at' => $time
                    ],
                    [
                        'account_id' => $account->id,
                        'name'       => 'import_dms',
                        'value'      => 1,
                        'created_at' => $time,
                        'updated_at' => $time
                    ]
                ]);
            }
        }
    }
}
