<?php
/**
 * File 2019_10_10_198000_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_6_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.6.0
 */
namespace Database\Seeds\v2_6_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_6_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.6.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Overwrite default e-mail templates if they're the same as what we ship in the 2.0.0-beta1 seeds.
        $id = 3;
        $this->updateTemplate(__DIR__.'/../2.0.0-beta1/emails/template_'.$id.'.twig', $id);

        $id = 32;
        $this->updateTemplate(__DIR__.'/../2.5.0/emails/template_'.$id.'.twig', $id);
    }

    /**
     * Overwrite email template if the updated time is the same as the created time.
     *
     * @param  string $template
     * @param  int    $id
     * @return void
     */
    private function updateTemplate($template, $id)
    {
        // Check template file exists.
        if (! file_exists($template)) {
            $this->note("[ERROR]: Failed to update email template '$id', template data file could not be found.");
            return;
        }

        // Check if the template has been modified.
        $unmodified = DB::table('email_template_data')
            ->where('template_id', $id)
            ->whereColumn('created_at', 'updated_at')
            ->whereNull('brand_id')
            ->whereNull('language_code')
            ->count();

        if ($unmodified) {
            DB::table('email_template_data')
                ->where('template_id', $id)
                ->whereColumn('created_at', 'updated_at')
                ->whereNull('brand_id')
                ->whereNull('language_code')
                ->update([ 'contents' => file_get_contents($template) ]);
        } else {
            $this->note("[INFO]: Unable to update email template '$id', template has likely been modified."
                . " Please read the 2.6.0 Release Notes (https://docs.supportpal.com/current/2.6.0).");
        }
    }
}
