<?php
/**
 * File 2020_03_06_150014_seed_permission_table.php
 *
 * @package    Database\Seeds\v3_0_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Seeds\v3_0_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;

/**
 * Class SeedPermissionTable
 *
 * @package    Database\Seeds\v3_0_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 3.0.0
 */
class SeedPermissionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $module = DB::table('module')->where('slug', 'Selfservice')->first();
        $role = DB::table('role')->first();
        if ($module === null || $role === null) {
            $this->note("Failed to find self-service module or system administrator role. Permissions have not been seeded.");

            return;
        }

        // Add new permission.
        $permissions = [
            [ 'module_id' => $module->id, 'name' => 'selfservicefeedbackform' ],
        ];

        foreach ($permissions as $permission) {
            $id = DB::table('permission')->insertGetId([
                'module_id'     => $permission['module_id'],
                'name'          => $permission['name'],
                'slug'          => '{"view":true,"create":true,"update":true,"delete":true}',
                'description'   => $permission['name'],
                'created_at'    => time(),
                'updated_at'    => time(),
            ]);

            // Enable permission for the global 'System Administrators' role.
            DB::table('permission_role')->insert([
                'permission_id' => $id,
                'role_id'       => $role->id
            ]);
        }

        $module = DB::table('module')->where('slug', 'Ticket')->first();

        // Delete feedback permission no longer needed.
        DB::table('permission')->where('module_id', $module->id)
            ->where('name', 'feedback')
            ->delete();
    }
}
