<?php
/**
 * File 2020_03_24_164500_seed_brand_table.php
 *
 * @package    Database\Seeds\v3_0_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.0.0
 */
namespace Database\Seeds\v3_0_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;

/**
 * Class SeedBrandTable
 *
 * @package    Database\Seeds\v3_0_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 3.0.0
 */
class SeedBrandTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Check if any brands have templates different to default.
        $modified = DB::table('brand')
            ->where('frontend_template', '!=', 'default')
            ->orWhere('operator_template', '!=', 'default')
            ->count();

        if ($modified) {
            DB::table('brand')
                ->update([
                    'frontend_template' => 'default',
                    'operator_template' => 'default'
                ]);

            $this->note("[INFO]: There is a new default template, any brands with custom templates set have been reset to the default."
                . " Please read the 3.0 Upgrade Guide (https://docs.supportpal.com/current/Upgrading+to+3.0+from+2.6#TemplateChanges).");
        }
    }
}
