<?php
/**
 * File 2020_05_05_201631_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v3_2_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 3.2.0
 */
namespace Database\Seeds\v3_2_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v3_2_0
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 3.2.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // PHP 7.4 support - implode(): Passing glue string after array is deprecated. Swap the parameters
        DB::update(
            "UPDATE `email_template_data`
                   SET `contents` = REPLACE(`contents`, '{{ implode(to_address|merge(cc_address)|merge(bcc_address), \', \') }}', '{{ implode(\', \', to_address|merge(cc_address)|merge(bcc_address)) }}')
                   WHERE `template_id` IN (1,4,5,18,19,23,24)"
        );
    }
}
