<?php
/**
 * File 2020_07_15_153852_seed_article_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Seeds\v3_3_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class SeedArticleTable
 */
class SeedArticleTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach (DB::cursor("SELECT `id`, `text` FROM `article` WHERE `plain_text` = ''") as $article) {
            DB::update("UPDATE `article` SET `plain_text` = ? WHERE `id` = ?", [
                html2text($article->text),
                $article->id
            ]);
        }
    }
}
