<?php
/**
 * File 2020_07_15_153908_seed_article_translation_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Seeds\v3_3_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class SeedArticleTranslationTable
 */
class SeedArticleTranslationTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach (DB::cursor("SELECT `article_id`, `text` FROM `article_translation` WHERE `plain_text` = ''") as $article) {
            DB::update("UPDATE `article_translation` SET `plain_text` = ? WHERE `article_id` = ?", [
                html2text($article->text),
                $article->article_id
            ]);
        }
    }
}
