<?php
/**
 * File 2020_08_24_163000_seed_permission_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Seeds\v3_3_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;

/**
 * Class SeedPermissionTable
 */
class SeedPermissionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $module = DB::table('module')->where('slug', 'Core')->first();
        $role = DB::table('role')->first();
        if ($module === null || $role === null) {
            $this->note("Failed to find core module or system administrator role. Permissions have not been seeded.");

            return;
        }

        // Add new permission.
        $permissions = [
            [ 'module_id' => $module->id, 'name' => 'integration' ],
        ];

        foreach ($permissions as $permission) {
            $id = DB::table('permission')->insertGetId([
                'module_id'     => $permission['module_id'],
                'name'          => $permission['name'],
                'slug'          => '{"view":true,"create":true,"update":true,"delete":true}',
                'description'   => $permission['name'],
                'created_at'    => time(),
                'updated_at'    => time(),
            ]);

            // Enable permission for the global 'System Administrators' role.
            DB::table('permission_role')->insert([
                'permission_id' => $id,
                'role_id'       => $role->id
            ]);
        }
    }
}
