<?php declare(strict_types=1);

namespace Database\Seeds\v3_4_0;

use Addons\Widgets\Todo\Controllers\Todo;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\Core\Controllers\Plugins\Facades\WidgetFactory;
use App\Modules\Core\Models\Repository\SettingsRepository;
use Exception;
use Illuminate\Support\Facades\DB;

use function sprintf;

class SeedWidgetTable extends Seeder
{
    protected $widgets = [
        Todo::IDENTIFIER,
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // We only want to run this as part of upgrades.
        // The same functionality exists in the install:operator command for new installations.
        if ($this->container->make(SettingsRepository::class)->isInstalled() === false) {
            return;
        }

        foreach ($this->widgets as $plugin) {
            $this->forceReactivation($plugin);
        }
    }

    /**
     * Force a plugin to deactivate and reactivate.
     *
     * @param  string $name
     * @return void
     */
    private function forceReactivation(string $name)
    {
        // The widget factory uses deferred loading (only when required).
        // We need to use it before `upgrade_available` will be set in the database.
        $plugin = WidgetFactory::getWidget($name);
        if ($plugin === null) {
            return;
        }

        // Get plugin, if upgrade pending.
        $model = DB::table('widget')->where('name', $name)->where('upgrade_available', 1)->first();
        if ($model === null) {
            return;
        }

        try {
            WidgetFactory::activate($plugin, true);
        } catch (Exception $e) {
            $this->note(sprintf('[ERROR]: Failed to upgrade \'%s\' widget. Widget has been deactivated. Please activate again via Plugins in the operator panel.', $name));
        }
    }
}
