<?php declare(strict_types=1);

namespace Database\Seeds\v3_6_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\Core\Controllers\Update\Manager\UpdateManager;
use Illuminate\Support\Facades\DB;

use function time;

class SeedScheduledTaskTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('scheduled_task')->insertGetId([
            'name'        => 'Update to the latest version',
            'description' => 'Automatically update the help desk to the latest available version.',
            'class'       => UpdateManager::class,
            'interval'    => 86385,
            'created_at'  => time(),
            'updated_at'  => time(),
        ]);
    }
}
