<?php declare(strict_types=1);

namespace Database\Seeds\v4_0_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Facades\File;
use Symfony\Component\Finder\Exception\DirectoryNotFoundException;
use Symfony\Component\Finder\Finder;

use function app_path;
use function base_path;

use const DIRECTORY_SEPARATOR;

class SeedWidgetTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        try {
            $widgets = Finder::create()
                ->directories()
                ->in(app_path('Widgets'))
                ->depth(0);
        } catch (DirectoryNotFoundException $e) {
            return;
        }

        // Migrate widgets to new addons folder.
        foreach ($widgets as $widget) {
            if ($widget->getRealPath() === false) {
                continue;
            }

            File::moveDirectory(
                $widget->getRealPath(),
                base_path('addons' . DIRECTORY_SEPARATOR . 'Widgets' . DIRECTORY_SEPARATOR . $widget->getBasename())
            );
        }
    }
}
