<?php declare(strict_types=1);

namespace Database\Seeds\v4_0_0;

use App\Exceptions\Handler;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Exception;
use Illuminate\Support\Facades\Artisan;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;

use function resource_path;
use function sprintf;

class SeedLanguages extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $dirs = resource_path('lang');
        $filesystem = new Filesystem;
        if (! $filesystem->exists($dirs)) {
            return;
        }

        $paths = Finder::create()
            ->directories()
            ->in($dirs)
            ->depth(0)
            ->notName(['en', 'es']);

        // Migrate languages to new addons folder.
        foreach ($paths as $path) {
            if ($path->getRealPath() === false) {
                continue;
            }

            try {
                Artisan::call('make:language', ['locale_code' => $path->getBasename()]);
            } catch (Exception $e) {
                if ($this->container->runningUnitTests()) {
                    throw $e;
                }

                Handler::reportException($e);
                $this->note(sprintf('Failed to migrate language %s to new add-ons framework.', $path->getRealPath()));
            }
        }
    }
}
