<?php declare(strict_types=1);

namespace Database\Seeds\v4_0_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;

use function now;

class SeedPermissionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /** @var mixed $module */
        $module = DB::table('module')->where('slug', 'Core')->first();
        /** @var mixed $role */
        $role = DB::table('role')->first();
        if ($module === null || $role === null) {
            $this->note('Failed to find core module or system administrator role. Permissions have not been seeded.');

            return;
        }

        // Add new permission.
        $permissions = [
            ['module_id' => $module->id, 'name' => 'system_health'],
        ];

        $timestamp = now()->getTimestamp();

        foreach ($permissions as $permission) {
            $id = DB::table('permission')->insertGetId([
                'module_id'     => $permission['module_id'],
                'name'          => $permission['name'],
                'slug'          => '{"view":true}',
                'description'   => $permission['name'],
                'created_at'    => $timestamp,
                'updated_at'    => $timestamp,
            ]);

            // Enable permission for the global 'System Administrators' role.
            DB::table('permission_role')->insert([
                'permission_id' => $id,
                'role_id'       => $role->id
            ]);
        }
    }
}
