<?php declare(strict_types=1);

namespace Database\Seeds\v4_0_0;

use App\Modules\Core\Controllers\Addons\Manager\UpdateManager;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

class SeedScheduledTaskTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('scheduled_task')->insert([
            'name'        => 'Check for add-on updates',
            'description' => 'Checks for available updates for installed add-ons from the marketplace.',
            'class'       => UpdateManager::class,
            'interval'    => 43185,
            'created_at'  => Carbon::now()->getTimestamp(),
            'updated_at'  => Carbon::now()->getTimestamp(),
        ]);
    }
}
