<?php declare(strict_types=1);

namespace Database\Seeds\v4_1_0;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;
use Illuminate\Support\Facades\Log;
use stdClass;

use function now;

class SeedTicketChannelSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /** @var stdClass|null $channel */
        $channel = DB::table('ticket_channel')->where('name', 'API')->first();
        if ($channel === null) {
            Log::warning('API channel not found. Data cannot be seeded.');

            return;
        }

        DB::table('ticket_channel_setting')
            ->insert([
                [
                    'channel_id' => $channel->id,
                    'name'       => 'append_ip_address',
                    'value'      => 1,
                    'created_at' => now()->getTimestamp(),
                    'updated_at' => now()->getTimestamp(),
                ],
                [
                    'channel_id' => $channel->id,
                    'name'       => 'check_spam',
                    'value'      => 1,
                    'created_at' => now()->getTimestamp(),
                    'updated_at' => now()->getTimestamp(),
                ],
                [
                    'channel_id' => $channel->id,
                    'name'       => 'enable_throttling',
                    'value'      => 1,
                    'created_at' => now()->getTimestamp(),
                    'updated_at' => now()->getTimestamp(),
                ],
            ]);
    }
}
