<?php declare(strict_types=1);

namespace Database\Seeds\v4_1_2;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Facades\DB;

class SeedChannelTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('ticket_channel')
            ->whereIn('name', ['Facebook', 'HelpWidget', 'Twitter', 'Twilio'])
            ->where(function ($query) {
                $query->where('version', '')
                    ->orWhereNull('version');
            })
            ->update(['version' => '1.0']);
    }
}
