<?php declare(strict_types=1);

/**
 * File DeactivatedAddon.php
 *
 * @copyright  Copyright (c) 2015-2019 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\Addons;

/**
 * Trait DeactivatedAddon
 */
trait DeactivatedAddon
{
    /**
     * Add-ons can run an installation routine when they are activated. This
     * will typically include adding default values, initialising database tables
     * and so on.
     *
     * @return boolean
     */
    public function activate()
    {
        //
    }

    /**
     * Deactivating serves as temporarily disabling the add-on, but the files still
     * remain. This function should typically clear any caches and temporary directories.
     *
     * @return boolean
     */
    public function deactivate()
    {
        //
    }

    /**
     * When an add-on is uninstalled, it should be completely removed as if it never
     * was there. This function should delete any created database tables, and any files
     * created outside of the add-on directory.
     *
     * @return boolean
     */
    public function uninstall()
    {
        //
    }
}
