<?php declare(strict_types=1);

/**
 * File Files.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\Addons\Support;

use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;

use function rmdir;
use function unlink;

/**
 * Class Files
 */
class Files
{
    /**
     * Recursively delete all files and directories in a given path
     *
     * @param  string $path Path to the directory.
     * @return bool true on success or false on failure.
     */
    public static function deleteDir($path = '')
    {
        if (empty($path)) {
            return false;
        }

        $it = new RecursiveDirectoryIterator($path, RecursiveDirectoryIterator::SKIP_DOTS);
        $files = new RecursiveIteratorIterator(
            $it,
            RecursiveIteratorIterator::CHILD_FIRST
        );
        foreach ($files as $file) {
            if ($file->isDir()) {
                rmdir($file->getRealPath());
            } else {
                unlink($file->getRealPath());
            }
        }

        return rmdir($path);
    }
}
