<?php declare(strict_types=1);

/**
 * Base Service
 *
 * @package    SupportPal\Core\Database\Services
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\Core\Database\Services;

use SupportPal\Core\Database\Models\BaseModel;

/**
 * Class BaseService
 *
 * @package    SupportPal\Core\Database\Services
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
class BaseService
{
    /**
     * Eloquent model.
     *
     * @var BaseModel
     */
    protected $builder;

    /**
     * BaseService constructor.
     *
     * @param BaseModel $model
     */
    public function __construct(BaseModel $model)
    {
        $this->model = $model;
    }
}
