<?php declare(strict_types=1);

namespace SupportPal\Core\Database\Traits;

use function sprintf;

trait MembershipTable
{
    public function updateMembership(string $col1, string $col2, int $oldId, int $newId): int
    {
        return $this->query()
            ->leftJoin(sprintf('%s as duplicate', $this->table), function ($join) use ($col1, $col2, $newId) {
                $join->on(sprintf('duplicate.%s', $col1), '=', sprintf('%s.%s', $this->table, $col1));
                $join->where(sprintf('duplicate.%s', $col2), $newId);
            })
            ->where(sprintf('%s.%s', $this->table, $col2), $oldId)
            ->whereNull(sprintf('duplicate.%s', $col1))
            ->update([sprintf('%s.%s', $this->table, $col2) => $newId]);
    }
}
