<?php declare(strict_types=1);

/**
 * File Controller
 *
 * @package    SupportPal\Core\Http\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace SupportPal\Core\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use SupportPal\Core\Http\Traits\ResponseHelpers;

use function array_map;
use function e;
use function is_array;
use function is_numeric;

/**
 * Class Controller
 *
 * @package    SupportPal\Core\Http\Controllers
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
abstract class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests, ResponseHelpers;

    /**
     * Instantiate a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Recursive function to run html entities on every element of an array.
     *
     * @param  mixed[] $array
     * @return array
     */
    protected function htmlEntities(array $array)
    {
        $callback = function ($item) {
            if (is_array($item) || $item instanceof Collection) {
                return $this->htmlEntities($item);
            }

            if ($item === null) {
                return null;
            }

            if (is_numeric($item)) {
                // Special case: (int) will strip off leading zeros (think ticket number), so we're just going to
                //               sanitize and return a string.
                if (Str::startsWith($item, '0')) {
                    return e($item);
                }

                return (int) e($item);
            }

            return e($item);
        };

        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $value = array_map($callback, $value);
            } elseif ($value instanceof Collection) {
                $value = $value->map($callback);
            } else {
                $value = $callback($value);
            }

            $array[$key] = $value;
        }

        return $array;
    }
}
