<?php

namespace Supportpal\HelpdeskBaseRequirements\Requirements;

use SupportPal\Requirements\Requirement;
use SupportPal\Requirements\RequirementGroup;
use SupportPal\Requirements\Translation\Translation;

class FilePermissions extends AbstractRequirement
{
    /** @var string */
    private $basePath;

    /**
     * @param string $basePath
     */
    public function __construct($basePath)
    {
        $this->basePath = $basePath;
    }

    public function getRequirementGroup()
    {
        $directories = array($this->basePath . '/bootstrap/cache');

        $writeableRequirements = array();
        foreach ($directories as $path) {
            $writeableRequirements[] = $this->makeDirPermissionRequirement($path);
        }

        return new RequirementGroup(
            new Translation('installer.file_writeable'),
            $writeableRequirements,
            array(),
            null,
            new Translation('installer.file_writeable_desc')
        );
    }

    /**
     * Make a directory permission requirement.
     *
     * @param  string $directory
     * @return AbstractRequirement
     */
    public function makeDirPermissionRequirement($directory)
    {
        return new Requirement(
            function () use ($directory) {
                return is_writable($directory);
            },
            new Translation($directory),
            new Translation('installer.permission_denied'),
            new Translation('installer.writable')
        );
    }
}
