<?php declare(strict_types=1);

namespace SupportPal\HelpdeskRequirements;

use Illuminate\Support\Facades\DB;
use PDO;
use Supportpal\HelpdeskBaseRequirements\Requirements\AbstractRequirement;
use SupportPal\Requirements\Requirement;
use SupportPal\Requirements\RequirementGroup;
use SupportPal\Requirements\Translation\Translation;

class DatabaseRequirements extends AbstractRequirement
{
    /**
     * Minimum MySQL versions.
     */
    const MIN_SERVER_VERSION = '5.6';
    const MIN_MYSQLND_VERSION = '5.0.9';

    /**
     * Check whether the MySQL server version is met.
     *
     * @return RequirementGroup
     */
    public function getRequirementGroup()
    {
        $replace = array('min' => self::MIN_SERVER_VERSION, 'mysqlnd_min' => self::MIN_MYSQLND_VERSION);
        $client_version = DB::getPdo()->getAttribute(PDO::ATTR_CLIENT_VERSION);
        $server_version = DB::getPdo()->getAttribute(PDO::ATTR_SERVER_VERSION);

        return new RequirementGroup(
            new Translation('installer.mysql_version'),
            array(
                new Requirement(
                    function () {
                        return DB::meetsServerVersion(self::MIN_SERVER_VERSION);
                    },
                    new Translation('installer.mysql_server_version', $replace),
                    new Translation('installer.mysql_version_not_found', array('version' => $server_version))
                ),
                new Requirement(
                    function () {
                        return DB::meetsClientVersion(self::MIN_MYSQLND_VERSION, self::MIN_SERVER_VERSION);
                    },
                    new Translation('installer.mysql_client_version', $replace),
                    new Translation('installer.mysql_version_not_found', array('version' => $client_version))
                ),
            ),
            array(),
            null,
            new Translation('installer.help_mysql_version')
        );
    }
}
