<?php declare(strict_types=1);

namespace SupportPal\Marketplace;

use Illuminate\Support\ServiceProvider;
use SupportPal\Marketplace\Http\Request;
use SupportPal\ProxyService\ProxyService;
use SupportPal\ProxyService\ProxyServiceProvider;

use function database_path;

class ClientServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->publishResources();
    }

    public function register()
    {
        // If it's already been registered this will return immediately.
        $this->app->register(ProxyServiceProvider::class);

        $this->registerApis();
    }

    private function registerApis(): void
    {
        $this->app->singleton(Request::class, function () {
            return new Request($this->app->make(ProxyService::class));
        });
    }

    /**
     * Register the resources that can be published using artisan.
     */
    protected function publishResources(): void
    {
        $this->publishes([
            __DIR__.'/../resources/migrations/' => database_path('migrations')
        ], 'migrations');
    }
}
